<?php
// Quick diagnostic script to check admin1@example.com role

$app = require __DIR__ . '/bootstrap/app.php';

$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use App\Models\User;

$user = User::where('email', 'admin1@example.com')->first();

if (!$user) {
    echo "❌ User admin1@example.com not found\n";
    echo "\n📍 Searching for admin users:\n";
    $admins = User::where('email', 'like', '%admin%')->get();
    foreach ($admins as $admin) {
        echo "  - {$admin->email}: role = {$admin->role} (type: " . gettype($admin->role) . ")\n";
    }
} else {
    echo "✅ User admin1@example.com found!\n";
    echo "  Name: {$user->name}\n";
    echo "  Role: {$user->role} (type: " . gettype($user->role) . ")\n";
    echo "  Tenant ID: {$user->tenant_id}\n";
    echo "  Status: {$user->status}\n";
    echo "\n🔍 Checking hasRole() methods:\n";
    echo "  hasRole('admin'): " . ($user->hasRole('admin') ? "✅ true" : "❌ false") . "\n";
    echo "  hasRole('admin1'): " . ($user->hasRole('admin1') ? "✅ true" : "❌ false") . "\n";
    echo "  hasRole('super-admin'): " . ($user->hasRole('super-admin') ? "✅ true" : "❌ false") . "\n";
    echo "  hasRole('super_admin'): " . ($user->hasRole('super_admin') ? "✅ true" : "❌ false") . "\n";
}

echo "\n";
?>
