<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\SalaryComponent;

class UnderworkedSalaryComponentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create a dedicated salary component for underworked deduction.
        // Use a combined label so it is usable in multilingual UI; admins can rename later.
        SalaryComponent::firstOrCreate(
            ['name' => 'Underworked Deduction (خصم نقصان ساعات)'],
            ['type' => 'deduction', 'description' => 'Automatically created component for deductions due to underworked hours']
        );
    }
}
