<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Company;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SuperAdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // إنشاء شركة افتراضية
        $company = Company::firstOrCreate(
            ['name' => 'الشركة الرئيسية'],
            [
                'email' => 'admin@company.com',
                'phone' => '01000000000',
                'address' => 'العنوان الرئيسي',
                'city' => 'القاهرة',
                'country' => 'مصر',
                'status' => 'active',
            ]
        );

        // إنشاء super_admin
        User::firstOrCreate(
            ['email' => 'superadmin@example.com'],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('password'),
                'company_id' => $company->id,
                'role' => 'super-admin',
                'status' => 'active',
            ]
        );

        // إنشاء admin للشركة الرئيسية
        User::firstOrCreate(
            ['email' => 'admin@example.com'],
            [
                'name' => 'Admin',
                'password' => Hash::make('password'),
                'company_id' => $company->id,
                'role' => 'admin',
                'status' => 'active',
            ]
        );

        $this->command->info('تم إنشاء حسابات السوبر أدمن والأدمن بنجاح!');
        $this->command->info('Super Admin: superadmin@example.com / password');
        $this->command->info('Admin: admin@example.com / password');
    }
}

