<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // تعريف الأدوار مع الصلاحيات المطلوبة
        $roles = [
            [
                'name' => 'super_admin',
                'description' => 'الوصول الكامل للنظام',
                'permissions' => ['*'] // '*' تعني جميع الصلاحيات
            ],
            [
                'name' => 'admin',
                'description' => 'مدير عام',
                'permissions' => [
                    'view_employees','create_employees','edit_employees','delete_employees',
                    'view_leaves','create_leaves','edit_leaves','delete_leaves','approve_leaves','reject_leaves','manage_leaves',
                    'view_payrolls','create_payrolls','edit_payrolls','delete_payrolls',
                    'view_attendance','create_attendance','edit_attendance','delete_attendance',
                    'view_loans','create_loans','edit_loans','delete_loans','approve_loans','reject_loans',
                    'view_deductions','create_deductions','edit_deductions','delete_deductions',
                    'view_assets','create_assets','edit_assets','delete_assets',
                    'view_training','create_training','edit_training','delete_training',
                    'view_users','create_users','edit_users','delete_users',
                    'view_reports',
                ]
            ],
            [
                'name' => 'hr',
                'description' => 'مدير الموارد البشرية',
                'permissions' => [
                    'view_employees','create_employees','edit_employees',
                    'view_leaves','create_leaves','edit_leaves','approve_leaves','reject_leaves','manage_leaves',
                    'view_attendance','create_attendance','edit_attendance',
                    'view_loans','create_loans','edit_loans',
                    'view_deductions','create_deductions','edit_deductions',
                    'view_reports','view_payrolls',
                ]
            ],
            [
                'name' => 'employee',
                'description' => 'موظف عادي',
                'permissions' => [
                    'view_own_profile',
                    'request_leave',
                    'view_own_payroll',
                    'view_own_attendance',
                ]
            ],
        ];

        foreach ($roles as $roleData) {
            Role::updateOrCreate(
                ['name' => $roleData['name']],
                [
                    'description' => $roleData['description'],
                    'permissions' => $roleData['permissions']
                ]
            );
        }
    }
}
