<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Loan;
use App\Models\LoanInstallment;
use Carbon\Carbon;

class LoanInstallmentSeeder extends Seeder
{
    public function run(): void
    {
        $loans = Loan::all();

        if ($loans->count() > 0) {
            foreach ($loans as $loan) {
                // نحدد عدد الأقساط بشكل عشوائي بين 3 و 10
                $installmentsCount = rand(3, 10);

                // مبلغ كل قسط مع تقريب لأقرب سنت
                $installmentAmount = round($loan->amount / $installmentsCount, 2);

                for ($i = 1; $i <= $installmentsCount; $i++) {
                    LoanInstallment::updateOrCreate(
                        [
                            'loan_id' => $loan->id,
                            'installment_number' => $i,
                        ],
                        [
                            'amount' => $installmentAmount,
                            'due_date' => Carbon::parse($loan->created_at)->addMonths($i),
                            'status' => 'pending',
                        ]
                    );
                }
            }
        } else {
            // في حالة عدم وجود قروض، إنشاء أقساط وهمية مرتبطة بقروض وهمية
            LoanInstallment::factory()->count(20)->create();
        }
    }
}
