<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LeaveTypesSeeder extends Seeder
{
    public function run()
    {
        $types = [
            ['code' => 'monthly', 'name' => 'شهرية', 'deducts_balance' => true, 'balance_kind' => 'monthly', 'affects_salary' => false, 'is_paid' => true],
            ['code' => 'annual', 'name' => 'سنوية', 'deducts_balance' => true, 'balance_kind' => 'annual', 'affects_salary' => false, 'is_paid' => true],
            ['code' => 'emergency', 'name' => 'طارئة', 'deducts_balance' => false, 'balance_kind' => null, 'affects_salary' => false, 'is_paid' => true],
            ['code' => 'sick', 'name' => 'مرضية', 'deducts_balance' => false, 'balance_kind' => null, 'affects_salary' => false, 'is_paid' => true],
            ['code' => 'maternity', 'name' => 'وضع / أمومة', 'deducts_balance' => false, 'balance_kind' => null, 'affects_salary' => false, 'is_paid' => true],
            ['code' => 'paternity', 'name' => 'أبوة', 'deducts_balance' => false, 'balance_kind' => null, 'affects_salary' => false, 'is_paid' => true],
            ['code' => 'unpaid', 'name' => 'بدون راتب', 'deducts_balance' => false, 'balance_kind' => null, 'affects_salary' => true, 'is_paid' => false],
        ];

        foreach ($types as $t) {
            DB::table('leave_types')->updateOrInsert(['code' => $t['code']], $t);
        }
    }
}
