<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Employee;
use App\Models\Position;
use App\Models\User;
use Carbon\Carbon;

class EmployeeSeeder extends Seeder
{
    public function run(): void
    {
        // جلب المناصب الموجودة
        $hrManagerPos = Position::where('name', 'مدير الموارد البشرية')->first();
        $devPos = Position::where('name', 'مطور برمجيات')->first();
        $accountantPos = Position::where('name', 'محاسب')->first();
        $marketerPos = Position::where('name', 'مسوق رقمي')->first();
        $opsManagerPos = Position::where('name', 'مدير عمليات')->first();

        // جلب المستخدمين
        $adminUser = User::where('email', 'admin@company.com')->first();
        $hrUser = User::where('email', 'hr@company.com')->first();
        $employeeUser = User::where('email', 'employee@company.com')->first();

        $employees = [
            [
                'employee_id' => 'EMP001',
                'name' => 'أحمد محمد',
                'email' => 'hr@company.com',
                'phone' => '0123456789',
                'position_id' => $hrManagerPos?->id,
                'department_id' => $hrManagerPos?->department_id,
                'hire_date' => Carbon::parse('2020-01-15'),
                'salary' => 1500.00,
                'status' => 'active',
                'user_id' => $hrUser?->id,
            ],
            [
                'employee_id' => 'EMP002',
                'name' => 'سارة علي',
                'email' => 'employee@company.com',
                'phone' => '0123456790',
                'position_id' => $devPos?->id,
                'department_id' => $devPos?->department_id,
                'hire_date' => Carbon::parse('2021-03-10'),
                'salary' => 1200.00,
                'status' => 'active',
                'user_id' => $employeeUser?->id,
            ],
            [
                'employee_id' => 'EMP003',
                'name' => 'خالد حسن',
                'email' => 'finance@company.com',
                'phone' => '0123456791',
                'position_id' => $accountantPos?->id,
                'department_id' => $accountantPos?->department_id,
                'hire_date' => Carbon::parse('2019-06-20'),
                'salary' => 1000.00,
                'status' => 'active',
                'user_id' => $employeeUser?->id,
            ],
            [
                'employee_id' => 'EMP004',
                'name' => 'فاطمة عبدالله',
                'email' => 'training@company.com',
                'phone' => '0123456792',
                'position_id' => $marketerPos?->id,
                'department_id' => $marketerPos?->department_id,
                'hire_date' => Carbon::parse('2022-01-05'),
                'salary' => 900.00,
                'status' => 'active',
                'user_id' => $employeeUser?->id,
            ],
            [
                'employee_id' => 'EMP005',
                'name' => 'محمد عبدالله',
                'email' => 'admin@company.com',
                'phone' => '0123456793',
                'position_id' => $opsManagerPos?->id,
                'department_id' => $opsManagerPos?->department_id,
                'hire_date' => Carbon::parse('2018-09-12'),
                'salary' => 1800.00,
                'status' => 'active',
                'user_id' => $adminUser?->id,
            ]
        ];

        foreach ($employees as $employeeData) {
            // إنشاء الموظف فقط إذا كل من position_id و department_id موجودين
            if ($employeeData['position_id'] && $employeeData['department_id']) {
                Employee::updateOrCreate(
                    ['employee_id' => $employeeData['employee_id']],
                    $employeeData
                );
            }
        }
    }
}
