<?php

namespace Database\Seeders;

// use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // تشغيل المزروعة بالترتيب الصحيح
        $this->call([
            DepartmentSeeder::class,  // تشغيل أولاً
            PositionSeeder::class,    // تشغيل ثانيًا
            EmployeeSeeder::class,    // تشغيل بعد القسم والمنصب
            \Database\Seeders\LeaveTypesSeeder::class,
            RoleSeeder::class,        // تشغيل قبل المستخدمين
            \Database\Seeders\RolesAndPermissionsSeeder::class,
            UserSeeder::class,        // تشغيل بعد الأدوار
            // ... باقي المزروعة الأخرى (مثل LoanInstallmentSeeder، إلخ)
            // Seeder لإضافة العطلة المحددة
            \Database\Seeders\AddHolidaySeeder::class,
            \Database\Seeders\UnderworkedSalaryComponentSeeder::class,
        ]);
    }
}