<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            // التحقق من عدم وجود الحقل قبل الإضافة لتجنب الأخطاء
            if (!Schema::hasColumn('employees', 'incentives')) { // ✅ تم تغيير 'allowances' إلى 'incentives'
                // إضافة الحقل incentives كرقم عشري (مناسب للقيمة المالية)
                // يمكن جعله_nullable للسماح بقيمة صفرية
                $table->decimal('incentives', 10, 2)->nullable()->after('salary')->comment('الحوافز الشهرية'); // ✅ تم تحديث التعليق
            }

            // إضافة 7 حقول مكونات إضافية
            for ($i = 1; $i <= 7; $i++) {
                $columnName = "component_{$i}";
                if (!Schema::hasColumn('employees', $columnName)) {
                    // ✅ تغيير 'after' من 'allowances' إلى 'incentives'
                    $table->decimal($columnName, 10, 2)->nullable()->after('incentives')->comment("المكون الإضافي {$i}"); 
                }
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            // التحقق من وجود الحقول قبل الحذف لتجنب الأخطاء
            if (Schema::hasColumn('employees', 'incentives')) { // ✅ تم تغيير 'allowances' إلى 'incentives'
                $table->dropColumn('incentives'); // ✅ تم تغيير 'allowances' إلى 'incentives'
            }

            // حذف 7 حقول المكونات
            for ($i = 1; $i <= 7; $i++) {
                $columnName = "component_{$i}";
                if (Schema::hasColumn('employees', $columnName)) {
                    $table->dropColumn($columnName);
                }
            }
        });
    }
};