<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('leave_balances', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained('employees')->cascadeOnDelete();
            $table->integer('annual_granted')->default(0)->comment('عدد الأيام الممنوحة سنويًا');
            $table->integer('used_annual')->default(0)->comment('عدد الأيام المستخدمة من الإجازات السنوية');
            $table->integer('carry_forward')->default(0)->comment('أيام إجازات مرحّلة من السنة السابقة');
            $table->timestamps();

            // لضمان وجود سجل واحد فقط لكل موظف
            $table->unique('employee_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leave_balances');
    }
};