<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            // تأكد من أن الحقل يمكن أن يحتوي على NULL
            $table->integer('monthly_leave_days_allowed')->nullable(true)->change();
            // أو، إذا كنت تفضل تعيين قيمة افتراضية 0 بدلاً من NULL:
            // $table->integer('monthly_leave_days_allowed')->default(0)->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            // عكس التغيير: يمكن أن يكون الحقل NOT NULL مع قيمة افتراضية
            // لاحظ: إذا كانت هناك سجلات موجودة بقيمة NULL، فسيتعين عليك تعيين قيمة افتراضية أولًا قبل جعله NOT NULL
            // $table->integer('monthly_leave_days_allowed')->default(2)->change(); // أو القيمة الافتراضية الأصلية
            // أو جعله مطلوبًا مرة أخرى بعد التأكد من عدم وجود NULLs
            // $table->integer('monthly_leave_days_allowed')->nullable(false)->default(2)->change();
        });
    }
};