<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            // إضافة 7 حقول لتخزين أسماء المكونات
            for ($i = 1; $i <= 7; $i++) {
                $table->string("component_name_{$i}", 255)->nullable()->default(null);
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            // إزالة الحقول عند التراجع
            for ($i = 1; $i <= 7; $i++) {
                $table->dropColumn("component_name_{$i}");
            }
        });
    }
};