<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('employee_salary_histories', function (Blueprint $table) {
            $table->id();
            $table->foreignId('employee_id')->constrained()->onDelete('cascade');
            $table->date('effective_from')->index();
            $table->decimal('base_salary', 15, 2)->nullable();
            $table->decimal('incentives', 15, 2)->nullable();
            $table->decimal('overtime_rate', 12, 4)->nullable();
            $table->integer('monthly_leave_entitlement')->nullable();
            $table->integer('annual_leave_entitlement')->nullable();
            $table->json('components')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->text('note')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('employee_salary_histories');
    }
};
