<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // حقول التحكم في المستخدم
            $table->boolean('is_active')->default(true);
            $table->timestamp('suspended_at')->nullable();
            $table->text('suspension_reason')->nullable();
            $table->integer('suspended_by')->nullable();
            $table->timestamp('last_login_at')->nullable();
            $table->string('last_login_ip')->nullable();
            $table->integer('login_attempts')->default(0);
            $table->timestamp('locked_until')->nullable();
            $table->json('access_permissions')->nullable();
            $table->boolean('can_login')->default(true);
            $table->text('deactivation_reason')->nullable();
            $table->integer('deactivated_by')->nullable();
            $table->timestamp('deactivated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'is_active',
                'suspended_at',
                'suspension_reason',
                'suspended_by',
                'last_login_at',
                'last_login_ip',
                'login_attempts',
                'locked_until',
                'access_permissions',
                'can_login',
                'deactivation_reason',
                'deactivated_by',
                'deactivated_at'
            ]);
        });
    }
};
