<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('companies', function (Blueprint $table) {
            // حقول الفوترة والاشتراك
            $table->date('subscription_start_date')->nullable();
            $table->date('subscription_end_date')->nullable();
            $table->decimal('subscription_fee', 10, 2)->default(0);
            $table->string('billing_cycle')->default('monthly'); // monthly, yearly
            $table->enum('payment_status', ['paid', 'pending', 'overdue', 'cancelled'])->default('paid');
            $table->date('last_payment_date')->nullable();
            $table->date('next_payment_date')->nullable();
            $table->decimal('outstanding_amount', 10, 2)->default(0);
            $table->integer('grace_period_days')->default(7);
            $table->text('payment_notes')->nullable();
            $table->json('billing_settings')->nullable();
            
            // حقول التحكم والقيود
            $table->boolean('can_add_employees')->default(true);
            $table->boolean('can_process_payroll')->default(true);
            $table->boolean('can_access_reports')->default(true);
            $table->integer('max_employees')->nullable();
            $table->integer('current_employee_count')->default(0);
            $table->timestamp('suspended_at')->nullable();
            $table->text('suspension_reason')->nullable();
            $table->integer('suspended_by')->nullable();
            
            // حقول الإحصائيات
            $table->integer('total_logins')->default(0);
            $table->timestamp('last_login_at')->nullable();
            $table->json('usage_statistics')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('companies', function (Blueprint $table) {
            $table->dropColumn([
                'subscription_start_date',
                'subscription_end_date',
                'subscription_fee',
                'billing_cycle',
                'payment_status',
                'last_payment_date',
                'next_payment_date',
                'outstanding_amount',
                'grace_period_days',
                'payment_notes',
                'billing_settings',
                'can_add_employees',
                'can_process_payroll',
                'can_access_reports',
                'max_employees',
                'current_employee_count',
                'suspended_at',
                'suspension_reason',
                'suspended_by',
                'total_logins',
                'last_login_at',
                'usage_statistics'
            ]);
        });
    }
};
