<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add company_id to branches
        if (Schema::hasTable('branches')) {
            Schema::table('branches', function (Blueprint $table) {
                if (!Schema::hasColumn('branches', 'company_id')) {
                    $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
                }
            });
        }

        // Add company_id to employees
        if (Schema::hasTable('employees')) {
            Schema::table('employees', function (Blueprint $table) {
                if (!Schema::hasColumn('employees', 'company_id')) {
                    $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
                }
            });
        }

        // Add company_id to payrolls
        if (Schema::hasTable('payrolls')) {
            Schema::table('payrolls', function (Blueprint $table) {
                if (!Schema::hasColumn('payrolls', 'company_id')) {
                    $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
                }
            });
        }

        // Add company_id to loans
        if (Schema::hasTable('loans')) {
            Schema::table('loans', function (Blueprint $table) {
                if (!Schema::hasColumn('loans', 'company_id')) {
                    $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
                }
            });
        }

        // Add company_id to deductions
        if (Schema::hasTable('deductions')) {
            Schema::table('deductions', function (Blueprint $table) {
                if (!Schema::hasColumn('deductions', 'company_id')) {
                    $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
                }
            });
        }

        // Add company_id to leaves
        if (Schema::hasTable('leaves')) {
            Schema::table('leaves', function (Blueprint $table) {
                if (!Schema::hasColumn('leaves', 'company_id')) {
                    $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
                }
            });
        }

        // Add company_id to attendances
        if (Schema::hasTable('attendances')) {
            Schema::table('attendances', function (Blueprint $table) {
                if (!Schema::hasColumn('attendances', 'company_id')) {
                    $table->foreignId('company_id')->nullable()->constrained('companies')->onDelete('cascade');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        $tables = ['branches', 'employees', 'payrolls', 'loans', 'deductions', 'leaves', 'attendances'];
        
        foreach ($tables as $table) {
            Schema::table($table, function (Blueprint $t) {
                if (Schema::hasColumn($table, 'company_id')) {
                    $t->dropForeignIdFor('companies');
                    $t->dropColumn('company_id');
                }
            });
        }
    }
};
