<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('payroll_salary_components', function (Blueprint $table) {
            if (!Schema::hasColumn('payroll_salary_components', 'name')) {
                $table->string('name')->nullable()->after('salary_component_id');
            }
        });
    }

    public function down(): void
    {
        Schema::table('payroll_salary_components', function (Blueprint $table) {
            $table->dropColumn('name');
        });
    }
};
