<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            // إضافة الحقول المفقودة إذا لم تكن موجودة
            if (!Schema::hasColumn('payrolls', 'total_salary')) {
                $table->decimal('total_salary', 12, 2)->default(0)->after('incentives');
            }
            if (!Schema::hasColumn('payrolls', 'net_salary')) {
                $table->decimal('net_salary', 12, 2)->default(0)->after('total_salary');
            }
            if (!Schema::hasColumn('payrolls', 'paid_off_amount')) {
                $table->decimal('paid_off_amount', 12, 2)->default(0)->after('net_salary');
            }
            if (!Schema::hasColumn('payrolls', 'notes')) {
                $table->text('notes')->nullable()->after('paid_off_amount');
            }
        });
    }

    public function down(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            $table->dropColumn(['total_salary', 'net_salary', 'paid_off_amount', 'notes']);
        });
    }
};
