<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->decimal('deduction_hourly_rate', 10, 2)->nullable()->default(0)->after('overtime_hourly_rate')
                  ->comment('ساعة خصم النقص - المبلغ الذي يخصم من الموظف عن كل ساعة نقص');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            $table->dropColumn('deduction_hourly_rate');
        });
    }
};
