<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('leaves', function (Blueprint $table) {
            if (!Schema::hasColumn('leaves', 'approval_modified')) {
                $table->boolean('approval_modified')->default(false)->after('is_unpaid_deduction_applied');
            }
            if (!Schema::hasColumn('leaves', 'approval_modified_at')) {
                $table->timestamp('approval_modified_at')->nullable()->after('approval_modified');
            }
            if (!Schema::hasColumn('leaves', 'approval_modified_by')) {
                $table->unsignedBigInteger('approval_modified_by')->nullable()->after('approval_modified_at');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('leaves', function (Blueprint $table) {
            if (Schema::hasColumn('leaves', 'approval_modified_by')) {
                $table->dropColumn('approval_modified_by');
            }
            if (Schema::hasColumn('leaves', 'approval_modified_at')) {
                $table->dropColumn('approval_modified_at');
            }
            if (Schema::hasColumn('leaves', 'approval_modified')) {
                $table->dropColumn('approval_modified');
            }
        });
    }
};
