<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('attendances', function (Blueprint $table) {
            // Add leave_id column if it doesn't exist
            if (!Schema::hasColumn('attendances', 'leave_id')) {
                $table->foreignId('leave_id')
                    ->nullable()
                    ->constrained('leaves')
                    ->onDelete('cascade');
            }
        });
    }

    public function down(): void
    {
        Schema::table('attendances', function (Blueprint $table) {
            if (Schema::hasColumn('attendances', 'leave_id')) {
                $table->dropForeign(['leave_id']);
                $table->dropColumn('leave_id');
            }
        });
    }
};
