<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // Change leave_type from enum to string to allow dynamic codes like 'monthly'
        DB::statement("ALTER TABLE `leaves` MODIFY `leave_type` VARCHAR(50) NOT NULL");
    }

    public function down(): void
    {
        // Revert to original enum (may fail if table contains values not in this enum)
        DB::statement("ALTER TABLE `leaves` MODIFY `leave_type` ENUM('annual','sick','emergency','maternity','paternity','unpaid') NOT NULL");
    }
};
