<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            if (!Schema::hasColumn('leaves', 'unpaid_deducted_days')) {
                $table->integer('unpaid_deducted_days')->nullable()->default(0)->after('deductible_days')->comment('Portion of deductible days that will be deducted from salary (unpaid part)');
            }
            if (!Schema::hasColumn('leaves', 'paid_days')) {
                $table->integer('paid_days')->nullable()->after('days_count')->comment('Calendar days considered paid (informational)');
            }
            if (!Schema::hasColumn('leaves', 'unpaid_days')) {
                $table->integer('unpaid_days')->nullable()->after('paid_days')->comment('Calendar days considered unpaid (informational)');
            }
        });
    }

    public function down(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            if (Schema::hasColumn('leaves', 'unpaid_deducted_days')) {
                $table->dropColumn('unpaid_deducted_days');
            }
            if (Schema::hasColumn('leaves', 'paid_days')) {
                $table->dropColumn('paid_days');
            }
            if (Schema::hasColumn('leaves', 'unpaid_days')) {
                $table->dropColumn('unpaid_days');
            }
        });
    }
};
