<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            // Store days that fall on weekly-off or official holidays (as JSON array of dates)
            // Example: ["2025-11-23", "2025-11-25"] if those days are holidays/weekly-off
            if (!Schema::hasColumn('leaves', 'excluded_days')) {
                $table->json('excluded_days')->nullable()->comment('Days in leave span that fall on weekly-off or holidays, should not be deducted');
            }

            // Store count of excluded days for quick calculation
            if (!Schema::hasColumn('leaves', 'excluded_days_count')) {
                $table->integer('excluded_days_count')->nullable()->default(0)->comment('Count of days excluded from deduction (weekly-off, holidays)');
            }

            // Deductible days = days_count - excluded_days_count
            if (!Schema::hasColumn('leaves', 'deductible_days')) {
                $table->integer('deductible_days')->nullable()->comment('Actual days to deduct from balance/salary = days_count - excluded_days_count');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leaves', function (Blueprint $table) {
            $table->dropColumn(['excluded_days', 'excluded_days_count', 'deductible_days']);
        });
    }
};
