<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('attendances', function (Blueprint $table) {
            if (Schema::hasColumn('attendances', 'leave_id')) {
                // create an index to speed up lookups by leave_id
                if (!Schema::hasColumn('attendances', 'leave_id_index')) {
                    $table->index('leave_id', 'attendances_leave_id_index');
                }
            }
        });
    }

    public function down(): void
    {
        Schema::table('attendances', function (Blueprint $table) {
            if (Schema::hasColumn('attendances', 'leave_id')) {
                $sm = Schema::getConnection()->getDoctrineSchemaManager();
                $indexes = array_map(function($i){ return $i->getName(); }, $sm->listTableIndexes('attendances'));
                if (in_array('attendances_leave_id_index', $indexes)) {
                    $table->dropIndex('attendances_leave_id_index');
                }
            }
        });
    }
};
