<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payroll_salary_components', function (Blueprint $table) {
            // استخدام JSON لتخزين تفاصيل الحساب (hours, rate, formula, note)
            if (!Schema::hasColumn('payroll_salary_components', 'meta')) {
                $table->json('meta')->nullable()->after('value');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payroll_salary_components', function (Blueprint $table) {
            if (Schema::hasColumn('payroll_salary_components', 'meta')) {
                $table->dropColumn('meta');
            }
        });
    }
};
