<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        if (!Schema::hasTable('deductions')) {
            // if table does not exist, nothing to do
            return;
        }

        if (!Schema::hasColumn('deductions', 'meta')) {
            Schema::table('deductions', function (Blueprint $table) {
                // add nullable JSON meta column to store flexible metadata
                $table->json('meta')->nullable()->after('notes');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        if (!Schema::hasTable('deductions')) {
            return;
        }

        if (Schema::hasColumn('deductions', 'meta')) {
            Schema::table('deductions', function (Blueprint $table) {
                $table->dropColumn('meta');
            });
        }
    }
};
