<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            if (!Schema::hasColumn('employees', 'deduct_if_underworked')) {
                $table->boolean('deduct_if_underworked')->default(false)->after('accrue_leaves');
            }
            if (!Schema::hasColumn('employees', 'overtime_paid')) {
                $table->boolean('overtime_paid')->default(true)->after('overtime_hourly_rate');
            }
        });
    }

    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            if (Schema::hasColumn('employees', 'deduct_if_underworked')) {
                $table->dropColumn('deduct_if_underworked');
            }
            if (Schema::hasColumn('employees', 'overtime_paid')) {
                $table->dropColumn('overtime_paid');
            }
        });
    }
};
