<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            if (!Schema::hasColumn('employees', 'overtime_hours_total')) {
                $table->decimal('overtime_hours_total', 10, 2)->default(0)->after('overtime_hourly_rate');
            }
            if (!Schema::hasColumn('employees', 'overtime_pay_total')) {
                $table->decimal('overtime_pay_total', 12, 2)->default(0)->after('overtime_hours_total');
            }
        });
    }

    public function down(): void
    {
        Schema::table('employees', function (Blueprint $table) {
            if (Schema::hasColumn('employees', 'overtime_pay_total')) {
                $table->dropColumn('overtime_pay_total');
            }
            if (Schema::hasColumn('employees', 'overtime_hours_total')) {
                $table->dropColumn('overtime_hours_total');
            }
        });
    }
};
