<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            if (!Schema::hasColumn('employees', 'overtime_hourly_rate')) {
                $table->decimal('overtime_hourly_rate', 8, 2)->default(0)->after('incentives');
            }
            if (!Schema::hasColumn('employees', 'accrue_leaves')) {
                $table->boolean('accrue_leaves')->default(true)->after('monthly_leave_days_allowed');
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            if (Schema::hasColumn('employees', 'overtime_hourly_rate')) {
                $table->dropColumn('overtime_hourly_rate');
            }
            if (Schema::hasColumn('employees', 'accrue_leaves')) {
                $table->dropColumn('accrue_leaves');
            }
        });
    }
};
