<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('holiday_years')) {
            Schema::create('holiday_years', function (Blueprint $table) {
                $table->id();
                $table->integer('year')->unique();
                $table->string('name')->nullable();
                $table->timestamps();
            });
        }

        if (!Schema::hasColumn('holidays', 'holiday_year_id')) {
            Schema::table('holidays', function (Blueprint $table) {
                $table->foreignId('holiday_year_id')->nullable()->after('is_paid')->constrained('holiday_years')->nullOnDelete();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('holidays', 'holiday_year_id')) {
            Schema::table('holidays', function (Blueprint $table) {
                $table->dropConstrainedForeignId('holiday_year_id');
            });
        }

        Schema::dropIfExists('holiday_years');
    }
};
