<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('employees', function (Blueprint $table) {
            if (!Schema::hasColumn('employees', 'annual_entitlement')) {
                $table->integer('annual_entitlement')->default(0)->after('monthly_leave_days_allowed');
            }
            if (!Schema::hasColumn('employees', 'weekly_off_days')) {
                $table->json('weekly_off_days')->nullable()->after('annual_entitlement');
            }
        });

        if (!Schema::hasTable('leave_types')) {
            Schema::create('leave_types', function (Blueprint $table) {
                $table->id();
                $table->string('code')->unique();
                $table->string('name');
                $table->boolean('deducts_balance')->default(false);
                $table->string('balance_kind')->nullable(); // 'monthly'|'annual'|null
                $table->boolean('affects_salary')->default(false);
                $table->boolean('is_paid')->default(true);
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('leave_balance_changes')) {
            Schema::create('leave_balance_changes', function (Blueprint $table) {
                $table->id();
                $table->foreignId('employee_id')->constrained()->cascadeOnDelete();
                $table->enum('kind', ['monthly','annual']);
                $table->integer('days_change');
                $table->date('effective_from');
                $table->text('note')->nullable();
                $table->foreignId('created_by')->nullable()->constrained('users');
                $table->timestamps();
            });
        }

        if (!Schema::hasColumn('leaves', 'leave_type_id')) {
            Schema::table('leaves', function (Blueprint $table) {
                $table->foreignId('leave_type_id')->nullable()->after('id')->constrained('leave_types');
                $table->foreignId('applied_balance_change_id')->nullable()->after('leave_type_id')->constrained('leave_balance_changes');
                $table->integer('deducted_days')->nullable()->after('applied_balance_change_id');
                $table->boolean('is_unpaid_deduction_applied')->default(false)->after('deducted_days');
                $table->json('balance_snapshot')->nullable()->after('is_unpaid_deduction_applied');
            });
        }

        if (!Schema::hasTable('holidays')) {
            Schema::create('holidays', function (Blueprint $table) {
                $table->id();
                $table->date('date')->unique();
                $table->string('name')->nullable();
                $table->boolean('is_paid')->default(true);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('employees', function (Blueprint $table) {
            if (Schema::hasColumn('employees', 'weekly_off_days')) {
                $table->dropColumn('weekly_off_days');
            }
            if (Schema::hasColumn('employees', 'annual_entitlement')) {
                $table->dropColumn('annual_entitlement');
            }
        });

        Schema::table('leaves', function (Blueprint $table) {
            if (Schema::hasColumn('leaves', 'balance_snapshot')) {
                $table->dropColumn('balance_snapshot');
            }
            if (Schema::hasColumn('leaves', 'is_unpaid_deduction_applied')) {
                $table->dropColumn('is_unpaid_deduction_applied');
            }
            if (Schema::hasColumn('leaves', 'deducted_days')) {
                $table->dropColumn('deducted_days');
            }
            if (Schema::hasColumn('leaves', 'applied_balance_change_id')) {
                $table->dropForeign(['applied_balance_change_id']);
                $table->dropColumn('applied_balance_change_id');
            }
            if (Schema::hasColumn('leaves', 'leave_type_id')) {
                $table->dropForeign(['leave_type_id']);
                $table->dropColumn('leave_type_id');
            }
        });

        Schema::dropIfExists('leave_balance_changes');
        Schema::dropIfExists('leave_types');
        Schema::dropIfExists('holidays');
    }
};
