<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Use raw SQL statements to avoid dependency on doctrine/dbal
        // Execute raw DDL statements without an explicit transaction because
        // some MySQL configurations/autocommit/DDL behavior may not support
        // transactional DDL. Each statement is tried and non-fatal errors are ignored.
        // Try to drop existing FK (if named as convention)
        try {
            DB::statement('ALTER TABLE `payroll_salary_components` DROP FOREIGN KEY `payroll_salary_components_salary_component_id_foreign`');
        } catch (\Throwable $e) {
            // ignore if FK name differs or doesn't exist
        }

        // Make column nullable
        try {
            DB::statement('ALTER TABLE `payroll_salary_components` MODIFY `salary_component_id` BIGINT UNSIGNED NULL');
        } catch (\Throwable $e) {
            // ignore errors and continue
        }

        // Re-add FK with ON DELETE SET NULL (ignore if cannot)
        try {
            DB::statement('ALTER TABLE `payroll_salary_components` ADD CONSTRAINT `payroll_salary_components_salary_component_id_foreign` FOREIGN KEY (`salary_component_id`) REFERENCES `salary_components`(`id`) ON DELETE SET NULL');
        } catch (\Throwable $e) {
            // ignore if cannot add (may already exist with different name)
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::beginTransaction();
        try {
            try {
                DB::statement('ALTER TABLE `payroll_salary_components` DROP FOREIGN KEY `payroll_salary_components_salary_component_id_foreign`');
            } catch (\Throwable $e) {
            }

            try {
                DB::statement('ALTER TABLE `payroll_salary_components` MODIFY `salary_component_id` BIGINT UNSIGNED NOT NULL');
            } catch (\Throwable $e) {
            }

            try {
                DB::statement('ALTER TABLE `payroll_salary_components` ADD CONSTRAINT `payroll_salary_components_salary_component_id_foreign` FOREIGN KEY (`salary_component_id`) REFERENCES `salary_components`(`id`) ON DELETE CASCADE');
            } catch (\Throwable $e) {
            }

            DB::commit();
        } catch (\Throwable $e) {
            DB::rollBack();
            throw $e;
        }
    }
};
