<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // تأكد من أن العمود غير موجود قبل إضافته لتجنب الأخطاء عند إعادة التشغيل
            if (!Schema::hasColumn('users', 'tenant_id')) {
                $table->foreignId('tenant_id')->nullable()->constrained('tenants')->onDelete('cascade');
            }
            // ملاحظة: يمكنك تعيين قيم افتراضية لـ tenant_id لجميع السجلات الحالية هنا (انظر ملاحظة أدناه)
            // DB::table('users')->whereNull('tenant_id')->update(['tenant_id' => 1]); // مثلاً، لربطها بمستأجر رئيسي افتراضيًا
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // تأكد من أن العمود موجود قبل حذفه
            if (Schema::hasColumn('users', 'tenant_id')) {
                $table->dropForeign(['tenant_id']); // حذف العلاقة الأجنبية أولاً
                $table->dropColumn('tenant_id');
            }
        });
    }
};