<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tenant_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('tenant_id')->constrained('tenants')->onDelete('cascade'); // ربط بالمستأجر
            $table->foreignId('package_id')->constrained('packages'); // ربط بالحزمة
            $table->timestamp('starts_at'); // تاريخ بدء الاشتراك
            $table->timestamp('ends_at'); // تاريخ انتهاء الاشتراك
            $table->string('status')->default('active'); // active, inactive, cancelled, expired...
            $table->decimal('price_paid', 10, 2); // السعر المدفوع مقابل هذا الاشتراك
            $table->string('currency', 3)->default('USD');
            $table->string('payment_method')->nullable(); // طريقة الدفع
            $table->string('payment_transaction_id')->nullable(); // معرف المعاملة (من gateway الدفع)
            $table->timestamps();

            // يمكنك إضافة حقول إضافية
            // $table->string('invoice_number')->nullable(); // رقم الفاتورة
            // $table->text('notes')->nullable(); // ملاحظات حول الاشتراك
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tenant_subscriptions');
    }
};