<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tenants', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // اسم الشركة
            $table->string('subdomain')->unique(); // subdomain الفريد (مثلاً: mycompany)
            $table->string('domain')->nullable()->unique(); // domain مخصص (اختياري) (مثلاً: hr.mycompany.com)
            $table->string('status')->default('active'); // active, inactive, suspended, trial_ended...
            $table->foreignId('package_id')->nullable()->constrained('packages'); // الحزمة الحالية للمستأجر
            $table->timestamp('trial_ends_at')->nullable(); // تاريخ انتهاء النسخة التجريبية (إذا وُجدت)
            $table->timestamp('subscription_ends_at')->nullable(); // تاريخ انتهاء الاشتراك
            $table->json('settings')->nullable(); // إعدادات مخصصة للمستأجر (JSON)
            $table->timestamps();

            // يمكنك إضافة حقول إضافية حسب احتياجاتك
            // $table->string('email')->nullable(); // بريد الشركة
            // $table->string('phone')->nullable(); // هاتف الشركة
            // $table->text('address')->nullable(); // عنوان الشركة
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tenants');
    }
};