<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('packages', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // مثلاً: Basic, Premium, Enterprise
            $table->text('description')->nullable(); // وصف الحزمة
            $table->json('permissions')->nullable(); // مصفوفة JSON للصلاحيات أو الميزات المسموح بها
            $table->integer('max_employees')->default(1); // الحد الأقصى لعدد الموظفين
            $table->integer('max_assets')->default(1); // الحد الأقصى لعدد الأصول (إذا كان النظام يدعم الأصول)
            $table->integer('max_storage_mb')->default(100); // الحد الأقصى لمساحة التخزين (إذا كان النظام يدعم التخزين)
            $table->decimal('price', 10, 2); // سعر الحزمة
            $table->string('currency', 3)->default('USD'); // العملة
            $table->integer('duration_days')->default(30); // مدة الحزمة بالأيام (للاشتراكات المدفوعة)
            $table->boolean('is_active')->default(true); // هل الحزمة متاحة للتسجيل؟
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('packages');
    }
};