<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('payroll_salary_components', function (Blueprint $table) {
            $table->id();
            $table->foreignId('payroll_id')->constrained('payrolls')->onDelete('cascade'); // ربط بالراتب
            $table->foreignId('salary_component_id')->constrained('salary_components')->onDelete('cascade'); // ربط باسم المكون
            $table->decimal('value', 10, 2); // القيمة المخصصة لهذا المكون في هذا الراتب
            $table->timestamps(); // created_at, updated_at

            // فهرس لتحسين الأداء
            $table->index(['payroll_id', 'salary_component_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payroll_salary_components');
    }
};