<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Use raw statement to modify enum -> varchar safely without requiring doctrine/dbal
        // This makes the `status` column able to accept the new statuses we introduced.
        DB::statement("ALTER TABLE `attendances` MODIFY `status` VARCHAR(50) NULL;");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // We do not attempt to restore the original ENUM definition because it may differ
        // between installs. Leave as VARCHAR to remain safe.
        // If you prefer restoring enum, update this down() with the original enum options.
        DB::statement("ALTER TABLE `attendances` MODIFY `status` VARCHAR(50) NULL;");
    }
};
