<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            // التحقق مما إذا كان العمود غير موجود بالفعل قبل إضافته
            if (!Schema::hasColumn('payrolls', 'leave_deduction')) {
                $table->decimal('leave_deduction', 10, 2)->default(0.00)->after('deductions')->comment('مبلغ خصم الإجازات');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            // التحقق مما إذا كان العمود موجودًا قبل حذفه
            if (Schema::hasColumn('payrolls', 'leave_deduction')) {
                $table->dropColumn('leave_deduction');
            }
        });
    }
};
