<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            // التحقق مما إذا كان العمود غير موجود بالفعل قبل إضافته
            if (!Schema::hasColumn('payrolls', 'leave_balance_after')) {
                $table->integer('leave_balance_after')->default(0)->after('net_salary')->comment('رصيد الإجازات المتراكم بعد دفع هذا الراتب');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payrolls', function (Blueprint $table) {
            // التحقق مما إذا كان العمود موجودًا قبل حذفه
            if (Schema::hasColumn('payrolls', 'leave_balance_after')) {
                $table->dropColumn('leave_balance_after');
            }
        });
    }
};
