<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('activities', function (Blueprint $table) {
            // جعل الأعمدة اختيارية (nullable) بدون تعيين قيمة افتراضية مباشرة
            $table->string('description')->nullable()->change();
            $table->string('subject_type')->nullable()->change();
            $table->unsignedBigInteger('subject_id')->nullable()->change();
            // فقط جعل properties nullable
            $table->json('properties')->nullable()->change();
            // ملاحظة: لا يمكن تعيين default('[]') مباشرة لعمود JSON في MySQL بهذه الطريقة.
            // سيتم التعامل مع القيم الافتراضية عند الإدراج أو في النموذج.
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('activities', function (Blueprint $table) {
            // العكس: إزالة nullable() إن لزم (اعتمادًا على الحالة الأصلية)
            // هذا مثال، وقد تحتاج إلى تعديله بناءً على الهيكل الأصلي لجدولك
            // $table->string('description')->nullable(false)->change(); // إذا كانت غير nullable أصلاً
            // $table->string('subject_type')->nullable(false)->change();
            // $table->unsignedBigInteger('subject_id')->nullable(false)->change();
            // $table->json('properties')->nullable(false)->change();
        });
    }
};