<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('activities', function (Blueprint $table) {
            // جعل الأعمدة اختيارية (nullable) فقط
            $table->string('description')->nullable()->change();
            $table->string('subject_type')->nullable()->change();
            $table->unsignedBigInteger('subject_id')->nullable()->change();
            // فقط جعل properties nullable - لا تضع default هنا
            $table->json('properties')->nullable()->change();
            // ❌ تأكد من أنه لا يوجد سطر مشابه لهذا:
            // $table->json('properties')->nullable()->default('[]')->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('activities', function (Blueprint $table) {
            // العكس: إزالة nullable() إن لزم (اعتمادًا على الحالة الأصلية)
            // $table->string('description')->nullable(false)->change();
            // $table->string('subject_type')->nullable(false)->change();
            // $table->unsignedBigInteger('subject_id')->nullable(false)->change();
            // $table->json('properties')->nullable(false)->change();
        });
    }
};