<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            if (!Schema::hasColumn('deductions', 'frequency')) {
                // تأكد من مطابقة هذا مع الترحيل الأصلي
                $table->string('frequency')->default('monthly')->after('amount');
            }
        });
    }

    public function down(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            if (Schema::hasColumn('deductions', 'frequency')) {
                $table->dropColumn('frequency');
            }
        });
    }
};