<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // تعديل عمود الحالة لإضافة القيمة الجديدة "modified"
        $driver = config('database.default');
        $connection = config("database.connections.{$driver}.driver");

        // SQLite لا يدعم MODIFY في ALTER TABLE — نتجنبه خلال الاختبارات
        if ($connection === 'sqlite') {
            // لا نفعل شيئًا هنا لأن بيئة الاختبار تستخدم SQLite
            return;
        }

        DB::statement("
            ALTER TABLE leaves 
            MODIFY status ENUM('pending', 'approved', 'rejected', 'cancelled', 'modified') 
            NOT NULL DEFAULT 'pending'
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // الرجوع للوضع القديم بدون "modified"
        $driver = config('database.default');
        $connection = config("database.connections.{$driver}.driver");

        if ($connection === 'sqlite') {
            return;
        }

        DB::statement("
            ALTER TABLE leaves 
            MODIFY status ENUM('pending', 'approved', 'rejected', 'cancelled') 
            NOT NULL DEFAULT 'pending'
        ");
    }
};
