<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('employees', 'monthly_leave_days_allowed')) {
            Schema::table('employees', function (Blueprint $table) {
                // تغيير تعريف الحقل لحذف القيمة الافتراضية
                $table->integer('monthly_leave_days_allowed')->nullable(true)->change();
                // أو إذا كنت ترغب في أن يكون 0 كقيمة افتراضية بدلًا من NULL:
                // $table->integer('monthly_leave_days_allowed')->default(0)->change();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('employees', 'monthly_leave_days_allowed')) {
            Schema::table('employees', function (Blueprint $table) {
                // التراجع: يمكن إعادة القيمة الافتراضية القديمة أو البقاء بدونها
                $table->integer('monthly_leave_days_allowed')->default(2)->change(); // أو حذف القيمة الافتراضية مرة أخرى
            });
        }
    }
};