<?php
// File: database/migrations/xxxx_xx_xx_xxxxxx_update_notifications_table_to_use_uuid.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB; // لتنفيذ أوامر SQL مباشرة (إن لزم)

return new class extends Migration
{
    /**
     * Run the migrations.
     * إعادة إنشاء جدول notifications لدعم UUID
     * ملاحظة: سيؤدي هذا إلى فقدان البيانات الحالية في جدول الإشعارات إذا وُجدت.
     */
    public function up(): void
    {
        // حذف الجدول القديم (إذا وُجد). تأكد من عمل نسخة احتياطية إذا كانت البيانات مهمة.
        Schema::dropIfExists('notifications');

        // إعادة إنشاء الجدول بالهيكل الجديد باستخدام UUID
        Schema::create('notifications', function (Blueprint $table) {
            $table->uuid('id')->primary(); // العمود id من نوع uuid وتعيينه كمفتاح أساسي
            $table->string('type');
            $table->morphs('notifiable'); // يُنشئ notifiable_id و notifiable_type مع فهرس تلقائي
            $table->json('data');
            $table->timestamp('read_at')->nullable();
            $table->timestamps();
            // لا حاجة لإضافة $table->index(['notifiable_type', 'notifiable_id']); يدويًا
            // لأن $table->morphs('notifiable'); يُنشئ هذا الفهرس تلقائيًا في Laravel.
            // ومع ذلك، فإن إعادة إنشاء الجدول قد تتسبب في فقدان الفهرس في بعض الحالات أو أن Laravel لا يُنشئه دائمًا في كل إصدار بنفس الطريقة.
            // لذا، إذا واجهت خطأ لاحقًا بسبب تكرار اسم الفهرس، قم بإزالة السطر أدناه.
            // $table->index(['notifiable_type', 'notifiable_id']); // فهرس لتحسين الأداء (مكرر محتمل)
        });
    }

    /**
     * Reverse the migrations.
     * العودة للهيكل القديم (إذا لزم)
     */
    public function down(): void
    {
        // حذف الجدول الجديد
        Schema::dropIfExists('notifications');

        // إعادة إنشاء الجدول بالهيكل القديم (BIGINT AUTO_INCREMENT)
        Schema::create('notifications', function (Blueprint $table) {
            $table->id(); // يعادل bigIncrements('id')
            $table->string('type');
            $table->morphs('notifiable'); // يُنشئ notifiable_id و notifiable_type مع فهرس تلقائي
            $table->json('data');
            $table->timestamp('read_at')->nullable();
            $table->timestamps();
            // لا حاجة لإضافة $table->index(['notifiable_type', 'notifiable_id']); يدويًا
            // لأن $table->morphs('notifiable'); يُنشئ هذا الفهرس تلقائيًا.
            // $table->index(['notifiable_type', 'notifiable_id']); // فهرس لتحسين الأداء (مكرر محتمل)
        });
    }
};