<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('activities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null'); // المستخدم الذي قام بالنشاط
            $table->string('description'); // وصف النشاط
            $table->morphs('subject'); // ربط مرن بالكيان المتأثر (اختياري)
            $table->json('properties')->nullable(); // بيانات إضافية
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('activities');
    }
};