<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // إضافة العمود method كعمود من نوع 'string' (أو 'enum' إذا كنت تفضل التحديد الدقيق)
            // ويجوز أن يكون فارغًا (nullable)
            // ووضعه بعد العمود end_date (يمكنك تعديل 'after' حسب الترتيب المطلوب في الجدول)
            $table->string('method')->nullable()->after('end_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // التحقق من وجود العمود قبل محاولة حذفه (لتجنب الأخطاء عند التراجع)
            if (Schema::hasColumn('deductions', 'method')) {
                $table->dropColumn('method');
            }
        });
    }
};