<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // إضافة العمود end_date كعمود من نوع 'date' ويجوز أن يكون فارغًا (nullable)
            // ووضعه بعد العمود is_monthly (يمكنك تعديل 'after' حسب الترتيب المطلوب في الجدول)
            $table->date('end_date')->nullable()->after('is_monthly');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('deductions', function (Blueprint $table) {
            // التحقق من وجود العمود قبل محاولة حذفه (لتجنب الأخطاء عند التراجع)
            if (Schema::hasColumn('deductions', 'end_date')) {
                $table->dropColumn('end_date');
            }
        });
    }
};